/*
 * 
 */
package gov.va.vinci.dart.db;

import gov.va.vinci.dart.biz.Event;
import gov.va.vinci.dart.biz.EventSummary;

import java.util.List;

/**
 * The Interface EventDAO.
 */
public interface EventDAO {

    /**
     * Save.
     *
     * @param event
     *            the event
     */
    public void save(final Event event);

    /**
     * Delete.
     *
     * @param event
     *            the event
     */
    public void delete(final Event event);

    /**
     * List by activity id.
     *
     * @param activityId
     *            the activity id
     * @return the list
     */
    List<Event> listByActivityId(final int activityId);

    /**
     * Delete Events for corresponding event type and request
     *
     * @param eventTypeId
     *            the event type if
     * @param requestId
     *            the request id           
     */
    public void deleteByEventAndRequest(final int eventTypeId, final int requestId);

    
    /**
     * List by request id.
     *
     * @param requestId
     *            the request id
     * @return the list
     */
    List<Event> listByRequestId(final int requestId);

    /**
     * List by event type and request id.
     *
     * @param eventTypeId
     *            the event type id
     * @param requestId
     *            the request id
     * @return the list
     */
    List<Event> listByEventTypeAndRequestId(final int eventTypeId, final int requestId);
    
    /**
     * List by activity id and group id.
     *
     * @param activityId
     *            the activity id
     * @param groupId
     *            the group id
     * @return the list
     */
    List<Event> listByActivityIdAndGroupId(final int activityId, final int groupId);

    /**
     * List by request id and group id.
     *
     * @param requestId
     *            the request id
     * @param groupId
     *            the group id
     * @return the list
     */
    List<Event> listByRequestIdAndGroupId(final int requestId, final int groupId);

    /**
     * List by activity id and group order.
     *
     * @param activityId
     *            the activity id
     * @param groupId
     *            the group id
     * @param isInitial
     *            the is initial
     * @return the list
     */
    List<Event> listByActivityIdAndGroupOrder(final int activityId, final int groupId, final boolean isInitial);

    /**
     * List by request id and group order.
     *
     * @param requestId
     *            the request id
     * @param groupId
     *            the group id
     * @param isInitial
     *            the is initial
     * @return the list
     */
    List<Event> listByRequestIdAndGroupOrder(final int requestId, final int groupId, final boolean isInitial);

    /**
     * List by event type and activity id and group id.
     *
     * @param eventTypeId
     *            the event type id
     * @param activityId
     *            the activity id
     * @param groupId
     *            the group id
     * @return the list
     */
    List<Event> listByEventTypeAndActivityIdAndGroupId(final int eventTypeId, final int activityId, final int groupId);

    /**
     * List by event type and activity id and group order.
     *
     * @param eventTypeId
     *            the event type id
     * @param activityId
     *            the activity id
     * @param groupId
     *            the group id
     * @param isInitial
     *            the is initial
     * @return the list
     */
    List<Event> listByEventTypeAndActivityIdAndGroupOrder(final int eventTypeId, final int activityId, final int groupId,
            final boolean isInitial);

    /**
     * List by event type and request id and group order.
     *
     * @param eventTypeId
     *            the event type id
     * @param requestId
     *            the request id
     * @param groupId
     *            the group id
     * @param isInitial
     *            the is initial
     * @return the list
     */
    List<Event> listByEventTypeAndRequestIdAndGroupOrder(final int eventTypeId, final int requestId, final int groupId,
            final boolean isInitial);

    /**
     * List by group.
     *
     * @param groupId
     *            the group id
     * @return the list
     */
    List<Event> listByGroup(final int groupId);

    /**
     * List summary by request id.
     *
     * @param requestId
     *            the request id
     * @return the list
     */
    List<EventSummary> listSummaryByRequestId(final int requestId);

    /**
     * List summary by activity id.
     *
     * @param activityId
     *            the activity id
     * @return the list
     */
    List<EventSummary> listSummaryByActivityId(final int activityId);

    /**
     * List by request id and group id and review id.
     *
     * @param requestId
     *            the request id
     * @param groupId
     *            the group id
     * @param reviewId
     *            the review id
     * @return the list
     */
    List<Event> listByRequestIdAndGroupIdAndReviewId(int requestId, int groupId, int reviewId);
}
